-- jeli funkcja o takiej nazwie ju istnieje to j usu
IF OBJECT_ID (N'dbo.getProductMembersRecHier2') IS NOT NULL
   DROP FUNCTION dbo.getProductMembersRecHier2
GO

-- utwrz rekurencyjn funkcj przyjmujc jeden parameter
-- funkcja zwraca tabel z informacjami dot. hierarchii wymiaru PRODUCT_PC
CREATE FUNCTION dbo.getProductMembersRecHier2 (@MEM_INFO VARCHAR(50))
RETURNS @ProductMembers TABLE 
(
	MEM_ID			INT NOT NULL,
	MEM_NAME		VARCHAR(50) NOT NULL,
	MEM_DESC		VARCHAR(255) NOT NULL,
	MEM_PID			INT NOT NULL,
	MEM_LEVEL		INT NOT NULL,
	MEM_HIER		VARCHAR(255) NOT NULL,
	MEM_HIER_NAMES		VARCHAR(255) NOT NULL
)
AS
BEGIN

-- utwrz tymczasowy zbir o strukturze takiej jak tabela wynikowea
WITH Members(MEM_ID, MEM_NAME, MEM_DESC, MEM_PID, MEM_LEVEL, MEM_HIER, MEM_HIER_NAMES) AS
-- wstaw do niej informacje o pierwszym elemencie,
-- ktrego nazw lub identyfikator przekazano w parametrze @MEM_INFO
    (SELECT	MEM_ID, 
		MEM_NAME, 
		MEM_DESC, 
		MEM_PID, 
-- 1, bo poziom wyjciowy, od ktrego zaczynamy przegldanie hierarchii
		1 AS MEM_LELEL, 
		-- przepisz dwukrotnie nazw pierwszego elementu
		CAST(MEM_NAME AS VARCHAR(255)) AS MEM_HIER, 
		CAST(MEM_NAME AS VARCHAR(255)) AS MEM_HIER_NAMES
	FROM PRODUCT_PC
	WHERE	MEM_NAME = @MEM_INFO OR 
			MEM_ID = 
			(CASE
				WHEN ISNUMERIC(@MEM_INFO)=0 
				THEN 0 
				ELSE @MEM_INFO
			 END)
					
	UNION ALL
-- do zbioru tymczasowego doacz informacje z tabeli wymiaru

	SELECT	P.MEM_ID, 
		P.MEM_NAME, 
		P.MEM_DESC, 
		P.MEM_PID, 
		-- dla kolejnego poziomu dodaj 1 do poziomu rodzica (ze zbioru Members)
		M.MEM_LEVEL + 1, 
		-- powtrz znak | tyle razy, ile wynosi numer aktualnego poziomu
-- i docz nazw elementu
		CAST(REPLICATE('| ', M.MEM_LEVEL) + P.MEM_NAME AS VARCHAR(255)) AS MEM_HIER, 
		-- dodaj znak | i nazw element do tej samej kombinacji rodzica
		CAST(M.MEM_HIER_NAMES + ' | ' + P.MEM_NAME AS VARCHAR(255)) AS MEM_HIER_NAMES
	FROM PRODUCT_PC as P
         JOIN Members AS M ON P.MEM_PID = M.MEM_ID
    )

 -- wstaw do tabeli wynikowej rekordy ze zbioru tymczasowego
   INSERT @ProductMembers
   	SELECT MEM_ID, MEM_NAME, MEM_DESC, MEM_PID, MEM_LEVEL, MEM_HIER, MEM_HIER_NAMES
FROM Members

  -- aktualizuj kolumn MEM_LEVEL  tylko dla lici,
  -- ustaw warto iloci poziomw w wymiarze
	UPDATE @ProductMembers SET
		MEM_LEVEL = (SELECT MAX(MEM_LEVEL) FROM @ProductMembers)
		WHERE MEM_ID NOT IN (SELECT MEM_PID FROM PRODUCT_PC)

   RETURN
END
GO
